package com.ipresent.android;

import android.content.res.Resources;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.Toast;

import com.radaee.pdf.Document;
import com.radaee.pdf.Global;
import com.radaee.view.PDFViewPager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "PDF_Proguard";
    private static final String PDF_FILE_NAME = "multipage.pdf";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        File pdfFile = new File(getFilesDir(), PDF_FILE_NAME);
        if (!pdfFile.exists()) {
            try {
                InputStream in = getApplicationContext().getAssets().open(PDF_FILE_NAME);
                OutputStream out = new FileOutputStream(pdfFile);
                byte[] buf = new byte[1024];
                int len;
                while ((len = in.read(buf)) > 0)
                    out.write(buf, 0, len);
                in.close();
                out.close();
            } catch (Throwable t) {
                Log.e(TAG, "Error copying PDF from assets.");
                Toast.makeText(this, "Error copying PDF from assets", Toast.LENGTH_LONG).show();
                finish();
            }
        }

        Resources resources = getResources();
        String company = resources.getString(R.string.licence_company_name);
        String email = resources.getString(R.string.licence_email_address);
        String key = resources.getString(R.string.licence_key);
        // Licence type 2 = Premium
        Global.Init(this, 2, company, email, key);
        Global.debug_mode = BuildConfig.DEBUG;

        PDFViewPager m_vPDF = new PDFViewPager(this);
        ((ViewGroup)findViewById(android.R.id.content)).addView(m_vPDF);

        Document doc = new Document();
        int ret = doc.Open(pdfFile.getAbsolutePath(), null);
        Toast.makeText(this, "Open returned: " + ret, Toast.LENGTH_SHORT).show();

        m_vPDF.PDFOpen(doc, 2);
    }
}
